#include <bits/stdc++.h>
using namespace std;
using ll = long long;

struct Mast {
    ll x, h;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Mast> a(n);
    for (int i = 0; i < n; i++) cin >> a[i].x;
    for (int i = 0; i < n; i++) cin >> a[i].h;

    sort(a.begin(), a.end(), [](auto &p, auto &q){
        return p.x < q.x;
    });

    const ll INF = (1LL<<62);
    vector<ll> ans(n, INF);

    // LEVO ? DESNO
    stack<int> st;
    for (int i = 0; i < n; i++) {
        while (!st.empty()) {
            int j = st.top();
            ll y = a[j].h - (a[i].x - a[j].x);
            if (y >= a[i].h) {
                ans[i] = min(ans[i], y - a[i].h);
                break;
            }
            if (a[j].h <= a[i].h) st.pop();
            else break;
        }
        st.push(i);
    }

    // DESNO ? LEVO
    while (!st.empty()) st.pop();
    for (int i = n - 1; i >= 0; i--) {
        while (!st.empty()) {
            int j = st.top();
            ll y = a[j].h - (a[j].x - a[i].x);
            if (y >= a[i].h) {
                ans[i] = min(ans[i], y - a[i].h);
                break;
            }
            if (a[j].h <= a[i].h) st.pop();
            else break;
        }
        st.push(i);
    }

    for (int i = 0; i < n; i++) {
        if (ans[i] == INF) cout << -1 << '\n';
        else cout << ans[i] << '\n';
    }

    return 0;
}